 ; Ŀ
 ;   Gostak - suck a column of text into a column of blocks.               
 ;   Goo, do the same, erase the origin entities.                          
 ;   Caution - this is not a very subtle program.                          
 ;   Copyright 2003, 2004, 2007 - 2009 by Rocket Software Ltd.             
 ;   Currently doesn't work on Doshes, distimming not added yet.           
 ; 

 ; Ŀ
 ;   Atc - count the attributes in a block.                                
 ;   Takes one argument, an insertion ename.                               
 ;   Returns a number or nil.                                              
 ;   Note that the number of attributes in a block is not necessarily      
 ;   the same as the number in the matching block definition.              
 ; 
 (DEFUN ATC (enam / entt num)
  (if (and (setq entt (entget enam))
           (= (cdr (assoc 0 entt)) "INSERT")
           (assoc 66 entt))
      (progn
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0
                                    (entget (setq enam (entnext enam))))))
                  (setq num (1+ num)))))
 num)
 ; Ŀ
 ;   Atc end.                                                              
 ; 

 ; Ŀ
 ;   Foap - find the zero based position of an attribute in a block.       
 ;   Takes one argument, aprompt string.                                   
 ;   Returns a number or nil.                                              
 ; 
 (DEFUN FOAP (proma / enampt enam blnam blopt entt attnam atenam num fini)
  (if (and (setq enampt (entsel proma))
           (setq enam (car enampt))
           (setq blnam (cdr (assoc 2 (entget enam))))
           (setq blopt (cadr enampt))
           (setq entt (entget (car (nentselp blopt))))
           (setq attnam (cdr (assoc 2 entt)))
           (setq atenam (cdr (assoc -1 entt))))
      (progn
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0
                                    (entget (setq enam (entnext enam))))))
                  (if (equal atenam enam) (setq fini num))
                  (setq num (1+ num)))))
 fini)
 ; Ŀ
 ;   Foap end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Vtol: returns a list of enames ordered entity position.    
 ;   Arguments: Ss, a selection set of entities to order.                  
 ;              Dir, a direction - if this is either "X" or "Y" then the   
 ;                   entities are assumed to be arrayed in that direction, 
 ;                   if anything else then the routine uses the direction  
 ;                   in which they are most spread out.                    
 ;              Insa, if T and the entity is text or an attribute then     
 ;                    sort based on the insertion point rather than the    
 ;                    ten point.                                           
 ;                                                                         
 ;   This is the latest version: 2006.10.05, which sorts text by           
 ;   insertion point rather than ten point and in which setting the        
 ;   direction to nil doesn't cause a crash.                               
 ;   Also it works with attdefs as well as text.                           
 ;   It should replace all other uses of Vtol and Stol.                    
 ;                                                                         
 ;   Revamped 2009.07.28 to use Apply rather than Eval Cons 'Max List etc. 
 ;   This is less elegant but removes the 256 entity limitation.           
 ;   Also added the ability to sort by either ten point or insertion.      
 ;                                                                         
 ; 
 (DEFUN VTOL (ss dir insa / xposnam yposnam numm ent entt ten xpos ypos xx yy
                            pn maxx minx maxy miny xdif ydif poslst posnam
                                                       direct pos lastt order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (if (and insa (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF")))
             (setq ten (spit entt))
             (setq ten (cdr (assoc 10 entt))))
         (setq xpos (car ten))
         (setq ypos (cadr ten))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now evaluate the four lists.  The result will be the max and min      
 ;   values for the X and Y lists.                                         
 ; 
  (setq maxx (apply 'max xx))
  (setq minx (apply 'min xx))
  (setq maxy (apply 'max yy))
  (setq miny (apply 'min yy))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set direction variables to match whichever direction was given in     
 ;   the argument, if it was nil then deduce a direction.                  
 ; 
  (cond ((and (= (type dir) 'STR)
              (= (strcase dir) "X"))
          (setq poslst xx)                ; positions from X coord list
          (setq posnam xposnam)           ; position & ename list with X coord
          (setq direct 'min))             ; edit from smallest to largest X
        ((and (= (type dir) 'STR)
              (= (strcase dir) "Y"))
         (setq poslst yy)
         (setq posnam yposnam)
         (setq direct 'max))
        (T
 ; Ŀ
 ;   The default case: figure it out yourself.                             
 ;   Set vert to T if vertical, nil if horizontal.                         
 ;   If not sure, assume vertical.                                         
 ;   Could set strip to Quit and thus do so...                             
 ; 
         (cond ((> xdif ydif)             ; if (Xmax - Xmin) > (Ymax - Ymin)
                (setq poslst xx)          ; positions from X coord list
                (setq posnam xposnam)     ; position & ename list with X coord
                (setq direct 'min))       ; edit from smallest to largest X
               ((< xdif ydif)
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max))
               (T                         ; if not sure then call it vertical
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max)))))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (apply direct poslst))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq lastt (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq lastt (cdr lastt))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq lastt (append (list (nth pos poslst)) lastt))
                (setq pos (1- pos)))
         (setq poslst lastt)      ; poslst becomes lastt
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Vtol end.                                                             
 ; 

 ; Ŀ
 ;   Goo.                                                                  
 ; 
 (DEFUN C:GOO (/ snapp *error* ss txlen orlstt posse ilen orlsti pos num
                             ssa source destin sortyp entt asoc1 destyp excess)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if shk (write-line shk))
   (setvar "snapmode" snapp)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Get a selection set of text entities or inserts, count them.          
 ; 
  (prompt "\nSource text or blocks: ")
  (setq ss (ssget '((-4 . "<or") (-4 . "<and") (0 . "insert")
                                               (66 . 1) (-4 . "and>")
                                 (0 . "text") (-4 . "or>"))))
  (setq txlen (sslength ss))
 ; Ŀ
 ;   And get their enames as a list in vertical order.                     
 ; 
  (setq orlstt (vtol ss "" t))
 ; Ŀ
 ;   If the first source entity (assumed to be typical) is a block         
 ;   and has more than one attribute then ask which one to replace.        
 ; 
  (if (> (atc (nth 0 orlstt)) 1)
      (setq posse (foap (strcat "\nThose source blocks have more than one "
                                "attribute.  Please select one:"))))
 ; Ŀ
 ;   Get a selection set of text or attribute-bearing blocks, count them.  
 ; 
  (prompt "\nDestination text or blocks: ")
  (setq ss (ssget '((-4 . "<or") (-4 . "<and") (0 . "insert")
                                               (66 . 1) (-4 . "and>")
                                 (0 . "text") (-4 . "or>"))))
  (setq ilen (sslength ss))
 ; Ŀ
 ;   And get their enames as a list in vertical order.                     
 ; 
  (setq orlsti (vtol ss "" t))
 ; Ŀ
 ;   If the first destination block (taken to be a representative sample)  
 ;   has more than one attribute then ask which one to replace.            
 ; 
  (if (> (atc (nth 0 orlsti)) 1)
      (setq pos (foap (strcat "\nThose destination blocks have more than one "
                              "attribute. Please select one:"))))
 ; Ŀ
 ;   Initialize the position in both selection sets counter, make an       
 ;   empty ss.                                                             
 ; 
  (setq num 0)
  (setq ssa (ssadd))
 ; Ŀ
 ;   While there are source and destintion entities, suck the former into  
 ;   the latter.                                                           
 ; 
  (while (and (setq source (nth num orlstt))
              (setq destin (nth num orlsti)))
 ; Ŀ
 ;   Add the source entity name to ssa, the ss of things to delete.        
 ;   Deleting them all at once with the erase command allows them to be    
 ;   recovered with Oops.                                                  
 ;   If the source entity is a member of the destination set then don't    
 ;   add it to the ss to be erased.  This allows the same entities to be   
 ;   the source and destination without being erased.                      
 ; 
         (if (not (ssmemb source ss))
             (ssadd source ssa))
 ; Ŀ
 ;   Decide what type of entity the source is, get the assoc 1 list.       
 ; 
         (setq sortyp (cdr (assoc 0 (entget source)))) ; source type
         (cond ((= sortyp "INSERT")
                (if posse (repeat posse (setq source (entnext source))))
                (setq source (entnext source))
                (setq entt (entget source)))
               ((= sortyp "TEXT")
                (setq entt (entget source))))
         (setq asoc1 (assoc 1 entt))                   ; source string
 ; Ŀ
 ;   Decide what type of entity the destination is, deal with it.          
 ; 
         (setq destyp (cdr (assoc 0 (entget destin)))) ; destination type
         (cond ((= destyp "INSERT")
                (if pos (repeat pos (setq destin (entnext destin))))
                (setq destin (entnext destin))
                (setq entt (entget destin)))
               ((= destyp "TEXT")
                (setq entt (entget destin))))
         (entmod (subst asoc1 (assoc 1 entt) entt))
         (entupd destin)
         (setq num (1+ num)))
 ; Ŀ
 ;   Erase the source entities.                                            
 ; 
  (if (and ssa (> (sslength ssa) 0))
      (command ".erase" ssa ""))
 ; Ŀ
 ;   Sum up and warn the user of errors he has made.                       
 ; 
  (cond ((> ilen txlen)
         (setq excess (- ilen txlen))
         (prompt (strcat "\nCaution: " (itoa excess)
                         " Excess destination entit"
                         (if (= excess 1) "y." "ies."))))
        ((< ilen txlen)
         (setq excess (- txlen ilen))
         (prompt (strcat "\nCaution: " (itoa excess)
                         " Excess source entit"
                         (if (= excess 1) "y." "ies.")))))
 ; Ŀ
 ;   End.                                                                  
 ; 
  (*error* ())
 (princ))

 ; Ŀ
 ;   Gostak - version without erase.  The Dutch made me do it.             
 ; 
 (defun c:gostak ()
  (c:goo)
  (command "oops")
 (princ))

(princ)
